#!/bin/bash

# scan-imports.sh
# Script to run the jscodeshift codemod to detect @uhg-abyss/web/ui imports

# Check if jscodeshift is installed
if ! command -v npx &> /dev/null; then
  echo "Error: npx is not installed. Please install Node.js and npm."
  exit 1
fi

# Get the directory of this script
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Default directory to scan is the current directory
SCAN_DIR="${1:-$(pwd)}"

echo "Scanning for deprecated @uhg-abyss imports in: $SCAN_DIR"

# Run jscodeshift with our transform
# Using --silent flag to suppress worker messages but keeping stdout for warnings
npx jscodeshift \
  --silent \
  --extensions=js,jsx,ts,tsx \
  --parser=tsx \
  -t "$SCRIPT_DIR/detect-deprecated-imports.js" \
  "$SCAN_DIR" 2>/dev/null

echo "Scan complete. Check warnings above for any detected deprecated imports."